//LidPostHoles.scad;

//This is version 2022_03_11;
//It implements a new strategy;
//The previous strategy generated each 
//post with its hole;
//This strategy uses the module: LidPosts 
//to generate four posts without holes 
//with this module to generate the objects 
//for the holes;
//It generates objects, not holes, 
//and is used with a difference() command 
//to make the holes;

//Each hole object is just a simple cylinder;

//This module places the hole objects 
//where they are required;
//The calling module should not tinker 
//with that placement; 
//With luck, the holes in the posts 
//will align with those in the floor, 
//generated by LidScrewThreads;

include <BATT_Dimensions.scad>

module LidPostHoles()
{

echo("Begin LidPostHoles");
    
//DeltaZ is constant for all post holes;
//The posts must allow room for two floors 
//and the flange to align the case for the UNO;
DeltaZ = 3*FloorZ +PostLidHeight/2;

//Two holes for two posts on the front wall;
//echo("Post hole BL = ", LidBLx, LidBLy);
translate([LidBLx, LidBLy, DeltaZ])
    cylinder(h=2*PostLidHeight,
        d=PostLidTapPhi, 
        center=true, $fn=32);

//echo("Post BR = ", LidBRx, LidBRy);
translate([LidBRx, LidBRy, DeltaZ])
    cylinder(h=2*PostLidHeight,
        d=PostLidTapPhi, 
        center=true, $fn=32);

//Two posts on the rear wall;
//echo("Post TR = ", LidTRx, LidTRy);
translate([LidTRx, LidTRy, DeltaZ])
    cylinder(h=2*PostLidHeight,
        d=PostLidTapPhi, 
        center=true, $fn=32);

//echo("Post TL = ", LidTLx, LidTLy);
translate([LidTLx, LidTLy, DeltaZ])
    cylinder(h=2*PostLidHeight,
        d=PostLidTapPhi, 
        center=true, $fn=32);

}
//
